/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import panther.util.unicon.NodeToString;
import panther.util.unicon.SAXErrorHandler;

public class DOMUtil {
    public static String getAttributeValue(Node node, String string) {
        Node node2;
        String string2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return string2;
    }

    public static Map getAttributesFromNode(Node node) {
        HashMap hashMap = new HashMap();
        DOMUtil.getAttributesFromNode(hashMap, node);
        return hashMap;
    }

    public static void getAttributesFromNode(Map map, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                map.put(node2.getNodeName(), node2.getNodeValue());
            }
        }
    }

    public static List getNamedChildren(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static Node getNamedChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static String getNodeText(Node node) {
        NodeToString nodeToString = new NodeToString(node);
        nodeToString.setPrintTopLevelTag(false);
        return nodeToString.toString();
    }

    public static Document newDocument() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        return document;
    }

    public static Document parse(InputSource inputSource, boolean bl) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (bl) {
            documentBuilder.setErrorHandler(new SAXErrorHandler());
        }
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    public static Document parse(InputStream inputStream, boolean bl) throws Exception {
        return DOMUtil.parse(new InputSource(inputStream), bl);
    }

    public static Document parse(Reader reader, boolean bl) throws Exception {
        return DOMUtil.parse(new InputSource(reader), bl);
    }

    public static Document parse(String string, boolean bl) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (bl) {
            documentBuilder.setErrorHandler(new SAXErrorHandler());
        }
        Document document = documentBuilder.parse(string);
        return document;
    }
}

